<?php
session_start();
require 'db.php';

if (isset($_SESSION['user_id'])) {
    header("Location: index.php");
    exit;
}

$error = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $stmt = $pdo->prepare("SELECT * FROM users WHERE phone = ?");
    $stmt->execute([$_POST['phone']]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($user && password_verify($_POST['password'], $user['password'])) {
        $_SESSION['user_id'] = $user['id'];
        header("Location: index.php");
        exit;
    } else {
        $error = "Invalid phone or password.";
    }
}
?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <title>Login</title>
  <link rel="stylesheet" href="assets/css/styles.css">
</head>
<body>
  <main class="container">
    <div class="card">
      <h1>Login</h1>
      <?php if($error): ?>
        <p class="error"><?php echo htmlspecialchars($error); ?></p>
      <?php endif; ?>
      <form method="post" class="grid grid-2">
        <div>
          <label>Phone</label>
          <input class="input" type="text" name="phone" required>
        </div>
        <div>
          <label>Password</label>
          <input class="input" type="password" name="password" required>
        </div>
        <div style="grid-column:1 / -1">
          <button class="btn block" type="submit">Login</button>
        </div>
      </form>
    </div>
  </main>
</body>
</html>
