<?php
session_start();
require 'db.php';
if (!isset($_SESSION['user_id'])) { header("Location: user_profile.php"); exit; }
$user_id = $_SESSION['user_id'];
$stmt = $pdo->prepare("SELECT * FROM orders WHERE user_id = ? ORDER BY created_at DESC LIMIT 1");
$stmt->execute([$user_id]);
$order = $stmt->fetch(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8">
<title>My Order Status — Propane</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<meta http-equiv="refresh" content="8">
<style>
:root {
  --bg: #0f172a;
  --card: #1e293b;
  --text: #e2e8f0;
  --muted: #94a3b8;
  --primary: #3b82f6;
  --primary-dark: #1d4ed8;
  --success: #16a34a;
  --danger: #ef4444;
  --warn: #f59e0b;
}

body { margin:0; font-family:system-ui, sans-serif; background:var(--bg); color:var(--text); }
.container { max-width:600px; margin:auto; padding:16px; }

.header { display:flex; justify-content:space-between; align-items:center; background:#1e293b; padding:12px 16px; box-shadow:0 2px 8px rgba(0,0,0,0.4); position:sticky; top:0; z-index:50; }
.brand { display:flex; align-items:center; gap:10px; }
.brand .logo { width:32px; height:32px; border-radius:8px; background: linear-gradient(135deg,var(--primary),var(--primary-dark)); animation: float 3s ease-in-out infinite; }
@keyframes float { 0%,100%{transform:translateY(0);} 50%{transform:translateY(-3px);} }
.brand h1 { font-size:16px; font-weight:600; margin:0; }
.btn.secondary { background:#334155; color:#fff; padding:8px 12px; border-radius:8px; text-decoration:none; font-size:14px; transition:0.3s ease; }
.btn.secondary:hover { background:#475569; }

.card { background:var(--card); border-radius:16px; padding:20px; box-shadow:0 6px 16px rgba(0,0,0,0.4); transition: transform 0.3s ease, box-shadow 0.3s ease; margin-top:16px; }
.card:hover { transform: translateY(-3px); box-shadow:0 12px 28px rgba(0,0,0,0.5); }

h1 { margin-top:0; font-size:20px; }
.hr { height:1px; background: linear-gradient(90deg,transparent,rgba(148,163,184,.2),transparent); margin:14px 0; }
.muted { color:var(--muted); font-size:14px; }

.badge { padding:4px 10px; border-radius:999px; font-size:12px; border:1px solid rgba(148,163,184,.2); transition:0.3s; text-transform:capitalize; }
.badge.pending{background:#e0f2fe;color:#0284c7;border-color:#7dd3fc;}
.badge.accepted{background:#dbeafe;color:#3b82f6;border-color:#93c5fd;}
.badge.on_the_way{background:#dbeafe;color:#60a5fa;border-color:#38bdf8;}
.badge.delivered{background:#d1fae5;color:#16a34a;border-color:#4ade80;}
.badge.cancelled{background:#fee2e2;color:#dc2626;border-color:#fca5a5;}

.footer { text-align:center; color:var(--muted); font-size:13px; padding:18px; }

/* Responsive */
@media(max-width:600px){
  .brand h1 { font-size:14px; }
  .btn.secondary { padding:6px 10px; font-size:13px; }
}
</style>
</head>
<body>

<div class="header">
  <div class="brand">
    <div class="logo"></div>
    <h1>Propane Service</h1>
  </div>
  <a class="btn secondary" href="index.php">Back</a>
</div>

<main class="container">
  <div class="card">
    <h1>Latest Order</h1>
    <div class="hr"></div>
    <?php if ($order): ?>
      <p>Order #<?php echo $order['id']; ?></p>
      <p>Status: <span class="badge <?php echo htmlspecialchars($order['status']); ?>">
        <?php echo htmlspecialchars($order['status']); ?>
      </span></p>
      <p class="muted">Auto-refreshing every 8s…</p>
    <?php else: ?>
      <p>No orders yet.</p>
    <?php endif; ?>
  </div>
</main>

<div class="footer">© <?php echo date('Y'); ?> Propane Service</div>

</body>
</html>
