<?php
session_start();
require 'db.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: create_profile.php");
    exit;
}

$user_id = $_SESSION['user_id'];

// Fetch user info
$stmt = $pdo->prepare("SELECT * FROM users WHERE id=?");
$stmt->execute([$user_id]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);

// Handle update
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!empty($_POST['password'])) {
        $hashedPassword = password_hash($_POST['password'], PASSWORD_DEFAULT);
        $stmt = $pdo->prepare("UPDATE users 
                               SET name=?, phone=?, address=?, area_id=?, gps_lat=?, gps_lng=?, password=? 
                               WHERE id=?");
        $stmt->execute([
            $_POST['name'], $_POST['phone'], $_POST['address'], $_POST['area_id'],
            $_POST['gps_lat'], $_POST['gps_lng'], $hashedPassword, $user_id
        ]);
    } else {
        $stmt = $pdo->prepare("UPDATE users 
                               SET name=?, phone=?, address=?, area_id=?, gps_lat=?, gps_lng=? 
                               WHERE id=?");
        $stmt->execute([
            $_POST['name'], $_POST['phone'], $_POST['address'], $_POST['area_id'],
            $_POST['gps_lat'], $_POST['gps_lng'], $user_id
        ]);
    }

    header("Location: user_profile.php?updated=1");
    exit;
}

$areas = $pdo->query("SELECT * FROM areas")->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8">
<title>Edit Profile — Propane</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<style>
:root {
  --bg: #0f172a;
  --card: #1e293b;
  --text: #e2e8f0;
  --muted: #94a3b8;
  --primary: #3b82f6;
  --primary-dark: #1d4ed8;
  --success: #16a34a;
  --danger: #ef4444;
  --ring: 0 0 0 3px rgba(59,130,246,.25);
}

* { box-sizing: border-box; margin:0; padding:0; }
body {
  font-family: system-ui, -apple-system, Segoe UI, Roboto, sans-serif;
  background: var(--bg); color: var(--text); line-height:1.5;
}

.container { max-width: 600px; margin: auto; padding: 16px; }

.header {
  background: #1e293b; color: #fff; padding: 12px 16px;
  display: flex; align-items:center; justify-content: space-between;
  position: sticky; top:0; z-index:50; box-shadow: 0 2px 8px rgba(0,0,0,0.4);
}
.brand { display:flex; align-items:center; gap:10px; }
.brand .logo {
  width:32px; height:32px; border-radius:8px;
  background: linear-gradient(135deg,var(--primary),var(--primary-dark));
  box-shadow: 0 4px 12px rgba(0,0,0,0.3);
  animation: float 3s ease-in-out infinite;
}
@keyframes float { 0%,100%{transform:translateY(0);} 50%{transform:translateY(-3px);} }
.brand h1 { font-size:16px; font-weight:600; }

.card {
  background: var(--card); border-radius:16px; padding:20px;
  box-shadow: 0 6px 16px rgba(0,0,0,0.4);
  transition: transform 0.3s ease, box-shadow 0.3s ease;
}
.card:hover { transform: translateY(-3px); box-shadow: 0 12px 28px rgba(0,0,0,0.5); }

h1 { font-size:20px; margin-bottom:10px; }
label { display:block; margin-bottom:6px; font-weight:500; }
.input, select { width:100%; padding:12px; border-radius:10px;
  border:1px solid rgba(148,163,184,.25); background: var(--card);
  color: var(--text); outline:none; margin-bottom:12px;
  transition: all 0.3s ease;
}
.input:focus, select:focus { box-shadow: var(--ring); border-color: var(--primary); }

.btn {
  display:inline-flex; align-items:center; justify-content:center; gap:6px;
  padding:12px 16px; border-radius:12px; border:0; cursor:pointer;
  font-weight:600; background: var(--primary); color:#fff; transition: all 0.3s ease;
}
.btn:hover { background: var(--primary-dark); box-shadow:0 4px 12px rgba(59,130,246,0.4);}
.btn.block { width:100%; }

.success {
  background: var(--success); color:#fff; padding:10px 14px;
  border-radius:8px; text-align:center; margin-bottom:12px;
  animation: fadeIn 0.6s ease;
}
@keyframes fadeIn { from{opacity:0; transform:translateY(-5px);} to{opacity:1; transform:translateY(0);} }

.hr { height:1px; background: linear-gradient(90deg,transparent,rgba(148,163,184,.2),transparent); margin:14px 0; }

.footer { text-align:center; color:var(--muted); font-size:13px; padding:18px; }

/* Responsive */
@media(max-width:600px){
  h1 { font-size:18px; }
  .brand h1 { font-size:14px; }
  .card { padding:16px; }
}
</style>
<script>
function getGPSInto(latSelector,lngSelector,statusId){
  const status = document.querySelector(statusId);
  if(navigator.geolocation){
    status.textContent="Locating...";
    navigator.geolocation.getCurrentPosition(pos=>{
      document.querySelector(latSelector).value=pos.coords.latitude;
      document.querySelector(lngSelector).value=pos.coords.longitude;
      status.textContent="Location set!";
    }, err=>{ status.textContent="Failed to get location"; });
  } else { status.textContent="Geolocation not supported"; }
}
</script>
</head>
<body>

<div class="header">
  <div class="brand">
    <div class="logo"></div>
    <h1>Propane Service</h1>
  </div>
</div>

<main class="container">
  <div class="card">
    <h1>Edit Profile</h1>
    <?php if(isset($_GET['updated'])): ?>
      <p class="success">Profile updated successfully!</p>
    <?php endif; ?>
    <div class="hr"></div>
    <form method="post">
      <label>Name</label>
      <input class="input" type="text" name="name" value="<?php echo htmlspecialchars($user['name']); ?>" required>

      <label>Phone</label>
      <input class="input" type="text" name="phone" value="<?php echo htmlspecialchars($user['phone']); ?>" required>

      <label>New Password <span class="muted">(leave blank to keep current)</span></label>
      <input class="input" type="password" name="password">

      <label>Address</label>
      <input class="input" type="text" name="address" value="<?php echo htmlspecialchars($user['address']); ?>">

      <label>Area</label>
      <select class="input" name="area_id">
        <?php foreach($areas as $a): ?>
          <option value="<?php echo $a['id']; ?>" <?php echo ($a['id']==$user['area_id'])?'selected':''; ?>>
            <?php echo htmlspecialchars($a['name']); ?>
          </option>
        <?php endforeach; ?>
      </select>

      <label>GPS Latitude</label>
      <input id="gps_lat" class="input" type="text" name="gps_lat" value="<?php echo htmlspecialchars($user['gps_lat']); ?>">

      <label>GPS Longitude</label>
      <input id="gps_lng" class="input" type="text" name="gps_lng" value="<?php echo htmlspecialchars($user['gps_lng']); ?>">

      <button class="btn" type="button" onclick="getGPSInto('#gps_lat','#gps_lng','#gps_status')">Use my location</button>
      <span id="gps_status" class="muted" style="margin-left:10px;"></span>

      <button class="btn block" type="submit" style="margin-top:12px;">Update Profile</button>
    </form>
  </div>
</main>

<div class="footer">© <?php echo date('Y'); ?> Propane Service</div>

</body>
</html>
