<?php
session_start();
require 'db.php';
if (!isset($_SESSION['admin_id'])) { header("Location: admin_login.php"); exit; }

// Add new area
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['name']) && $_POST['name']!=='') {
    $pdo->prepare("INSERT INTO areas (name) VALUES (?)")->execute([$_POST['name']]);
    header("Location: admin_areas.php");
    exit;
}

// Delete area
if (isset($_GET['delete'])) {
    $stmt = $pdo->prepare("DELETE FROM areas WHERE id=?");
    $stmt->execute([$_GET['delete']]);
    header("Location: admin_areas.php");
    exit;
}

$areas = $pdo->query("SELECT * FROM areas ORDER BY id DESC")->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title>Manage Areas</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <link rel="stylesheet" href="assets/css/styles.css">
  <style>
    body { background:#0f172a; color:#e2e8f0; font-family:system-ui, sans-serif; margin:0; }
    .container { max-width:800px; margin:auto; padding:16px; }
    .header { display:flex; align-items:center; background:#1e293b; padding:12px 16px; box-shadow:0 2px 8px rgba(0,0,0,.4);}
    .brand { display:flex; align-items:center; gap:10px; }
    .logo { width:32px; height:32px; border-radius:8px; background:linear-gradient(135deg,#3b82f6,#1d4ed8); }
    h1,h2 { margin:0; font-weight:600; }
    .card { background:#1e293b; border-radius:16px; padding:20px; box-shadow:0 6px 16px rgba(0,0,0,.4); margin-top:16px;}
    .hr { height:1px; background:linear-gradient(90deg,transparent,rgba(148,163,184,.2),transparent); margin:14px 0;}
    .input { flex:1; padding:10px; border-radius:8px; border:1px solid #334155; background:#0f172a; color:#e2e8f0; }
    .btn { background:#3b82f6; border:none; color:#fff; padding:10px 16px; border-radius:8px; cursor:pointer; transition:.3s; }
    .btn:hover { background:#2563eb; }
    .btn.secondary { background:#475569; }
    table { width:100%; border-collapse:collapse; margin-top:10px; }
    th, td { padding:10px; text-align:left; border-bottom:1px solid #334155; }
    tr:hover { background:#0f172a; }
    a.btn-small { background:#ef4444; padding:6px 12px; border-radius:6px; font-size:13px; text-decoration:none; color:#fff; }
    a.btn-small:hover { background:#dc2626; }
    .footer { text-align:center; color:#94a3b8; font-size:13px; padding:18px; }
  </style>
</head>
<body>
  <div class="header">
    <div class="header-inner container" style="display:flex;justify-content:space-between;align-items:center;">
      <div class="brand"><div class="logo"></div><h1>Manage Areas</h1></div>
      <a class="btn secondary" href="admin_panel.php">Dashboard</a>
    </div>
  </div>

  <main class="container">
    <div class="card">
      <h2>Add Area</h2>
      <div class="hr"></div>
      <form method="post" style="display:flex;gap:10px">
        <input class="input" name="name" placeholder="Area name" required>
        <button class="btn" type="submit">Add</button>
      </form>
    </div>

    <div class="card">
      <h2>Existing Areas</h2>
      <div class="hr"></div>
      <table>
        <thead>
          <tr><th style="width:60px">ID</th><th>Name</th><th style="width:100px">Action</th></tr>
        </thead>
        <tbody>
          <?php foreach($areas as $a): ?>
            <tr>
              <td><?php echo $a['id']; ?></td>
              <td><?php echo htmlspecialchars($a['name']); ?></td>
              <td>
                <a class="btn-small" href="?delete=<?php echo $a['id']; ?>" onclick="return confirm('Delete this area?')">Delete</a>
              </td>
            </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>
  </main>

  <div class="footer">© <?php echo date('Y'); ?> Propane Service</div>
</body>
</html>
