<?php
session_start();
require 'db.php';

if (!isset($_SESSION['admin_id'])) {
    header("Location: admin_login.php");
    exit;
}

$id = $_GET['id'] ?? '';
if (!$id) {
    die("Invalid driver ID");
}

try {
    // First, check if driver exists
    $stmt = $pdo->prepare("SELECT id FROM drivers WHERE id = ?");
    $stmt->execute([$id]);
    if (!$stmt->fetch()) {
        die("Driver not found");
    }

    // Delete driver
    $pdo->prepare("DELETE FROM drivers WHERE id = ?")->execute([$id]);

    // Redirect back to drivers page
    header("Location: admin_drivers.php");
    exit;

} catch (PDOException $e) {
    die("Error deleting driver: " . $e->getMessage());
}
