<?php
session_start();
require 'db.php';

if (isset($_GET['logout'])) {
    if (isset($_SESSION['admin_id'])) {
        // Clear remember token
        $stmt = $pdo->prepare("UPDATE admin SET remember_token=NULL WHERE id=?");
        $stmt->execute([$_SESSION['admin_id']]);
    }
    unset($_SESSION['admin_id']);
    setcookie('admin_remember', '', time() - 3600, '/');
    session_regenerate_id(true);
    header("Location: admin_login.php");
    exit;
}

// Auto-login with cookie
if (!isset($_SESSION['admin_id']) && isset($_COOKIE['admin_remember'])) {
    $token = $_COOKIE['admin_remember'];
    $stmt = $pdo->prepare("SELECT * FROM admin WHERE remember_token=?");
    $stmt->execute([$token]);
    $admin = $stmt->fetch(PDO::FETCH_ASSOC);
    if ($admin) {
        $_SESSION['admin_id'] = $admin['id'];
        header("Location: admin_panel.php");
        exit;
    }
}

$count = (int)$pdo->query("SELECT COUNT(*) FROM admin")->fetchColumn();
$bootstrap = $count === 0;
$msg = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if ($bootstrap) {
        $hash = password_hash($_POST['password'], PASSWORD_DEFAULT);
        $stmt = $pdo->prepare("INSERT INTO admin (username, password_hash) VALUES (?,?)");
        $stmt->execute([$_POST['username'], $hash]);
        $msg = "Admin created. Please log in.";
        $bootstrap = false;
    } else {
        $stmt = $pdo->prepare("SELECT * FROM admin WHERE username=?");
        $stmt->execute([$_POST['username']]);
        $admin = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($admin && password_verify($_POST['password'], $admin['password_hash'])) {
            $_SESSION['admin_id'] = $admin['id'];

            // Persistent login token
            $token = bin2hex(random_bytes(32));
            setcookie('admin_remember', $token, time() + (10*365*24*60*60), "/"); // 10 years
            $stmt = $pdo->prepare("UPDATE admin SET remember_token=? WHERE id=?");
            $stmt->execute([$token, $admin['id']]);

            header("Location: admin_panel.php");
            exit;
        } else {
            $msg = "Invalid username or password";
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title>Admin Login</title>
  <link rel="stylesheet" href="assets/css/styles.css">
  <style>
    body { background:#0f172a; color:#e2e8f0; font-family:system-ui,sans-serif; margin:0; }
    .container { max-width:520px; margin:80px auto; padding:20px; }
    .card { background:#1e293b; border-radius:16px; padding:24px; box-shadow:0 6px 16px rgba(0,0,0,.4); }
    h1 { margin-top:0; font-weight:600; text-align:center; }
    .input { width:100%; padding:12px; margin:8px 0 16px 0; border-radius:8px; border:1px solid #334155; background:#0f172a; color:#e2e8f0; }
    .btn { background:#3b82f6; border:none; color:#fff; padding:12px; border-radius:8px; cursor:pointer; width:100%; transition:.3s; font-size:16px; }
    .btn:hover { background:#2563eb; }
    .badge { display:block; padding:10px; border-radius:8px; margin-top:12px; text-align:center; font-weight:500; }
    .badge.accepted { background:#16a34a; color:#fff; }
    .badge.cancelled { background:#dc2626; color:#fff; }
  </style>
</head>
<body>
  <main class="container">
    <div class="card">
      <h1><?php echo $bootstrap ? 'Create First Admin' : 'Admin Login'; ?></h1>
      <form method="post">
        <label>Username</label>
        <input class="input" type="text" name="username" required>
        <label>Password</label>
        <input class="input" type="password" name="password" required>
        <button class="btn" type="submit">
          <?php echo $bootstrap ? 'Create Admin' : 'Login'; ?>
        </button>
      </form>
      <?php if ($msg): ?>
        <span class="badge <?php echo ($bootstrap)?'accepted':'cancelled'; ?>">
          <?php echo htmlspecialchars($msg); ?>
        </span>
      <?php endif; ?>
    </div>
  </main>
</body>
</html>
