<?php
session_start();
require 'db.php';
if (!isset($_SESSION['admin_id'])) { 
    header("Location: admin_login.php"); 
    exit; 
}

// Default: today
$today = date('Y-m-d');
$from = $_GET['from'] ?? $today;
$to = $_GET['to'] ?? $today;
$driver = $_GET['driver'] ?? '';
$area = $_GET['area'] ?? '';
$status = $_GET['status'] ?? '';

// Build SQL dynamically
$sql = "SELECT o.*, u.name AS user_name, d.name AS driver_name, a.name AS area_name 
        FROM orders o 
        JOIN users u ON o.user_id=u.id 
        LEFT JOIN drivers d ON o.driver_id=d.id 
        LEFT JOIN areas a ON o.area_id=a.id 
        WHERE 1";
$params = [];

if ($from) { $sql .= " AND DATE(o.created_at) >= ?"; $params[] = $from; }
if ($to)   { $sql .= " AND DATE(o.created_at) <= ?"; $params[] = $to; }
if ($driver) { $sql .= " AND o.driver_id = ?"; $params[] = $driver; }
if ($area)   { $sql .= " AND o.area_id = ?"; $params[] = $area; }
if ($status) { $sql .= " AND o.status = ?"; $params[] = $status; }

$sql .= " ORDER BY o.created_at DESC";

$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$orders = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Dropdown data
$drivers = $pdo->query("SELECT id,name FROM drivers ORDER BY name")->fetchAll(PDO::FETCH_ASSOC);
$areas = $pdo->query("SELECT id,name FROM areas ORDER BY name")->fetchAll(PDO::FETCH_ASSOC);
$statuses = ['pending','accepted','assigned','delivered','cancelled'];

// Finance calculations
$totalOrders = count($orders);
$totalAmount = 0;
$totalDelivery = 0;
foreach ($orders as $o) {
    $totalAmount += $o['total_amount'] ?? 0;
    $totalDelivery += $o['delivery_fee'] ?? 0;
}
?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <title>Orders — Admin</title>
  <link rel="stylesheet" href="assets/css/styles.css">
  <style>
    .filters {display:grid;grid-template-columns:repeat(auto-fit,minmax(180px,1fr));gap:10px;margin-bottom:20px;}
    .finance-summary {display:flex;gap:20px;margin-bottom:20px;}
    .finance-summary .box {background:#f5f5f5;padding:15px;border-radius:8px;flex:1;text-align:center;}
    .quick-btns {margin-bottom:15px;}
    .quick-btns button{margin-right:5px;}
  </style>
</head>
<body>
<div class="header">
  <div class="header-inner container">
    <div class="brand"><div class="logo"></div><h1>Admin — Orders</h1></div>
    <a class="btn secondary" href="admin_panel.php">Dashboard</a>
  </div>
</div>

<main class="container">

  <div class="card">
    <h1>Orders & Finance</h1>

    <!-- Quick Date Buttons -->
    <div class="quick-btns">
      <form method="get" style="display:inline">
        <input type="hidden" name="from" value="<?= $today ?>">
        <input type="hidden" name="to" value="<?= $today ?>">
        <button class="btn small" type="submit">Today</button>
      </form>
      <form method="get" style="display:inline">
        <input type="hidden" name="from" value="<?= date('Y-m-d', strtotime('monday this week')) ?>">
        <input type="hidden" name="to" value="<?= date('Y-m-d', strtotime('sunday this week')) ?>">
        <button class="btn small" type="submit">This Week</button>
      </form>
      <form method="get" style="display:inline">
        <input type="hidden" name="from" value="<?= date('Y-m-01') ?>">
        <input type="hidden" name="to" value="<?= date('Y-m-t') ?>">
        <button class="btn small" type="submit">This Month</button>
      </form>
    </div>

    <!-- Filters -->
    <form method="get" class="filters">
      <div>
        <label>From</label>
        <input type="date" name="from" value="<?= htmlspecialchars($from) ?>">
      </div>
      <div>
        <label>To</label>
        <input type="date" name="to" value="<?= htmlspecialchars($to) ?>">
      </div>
      <div>
        <label>Driver</label>
        <select name="driver">
          <option value="">All</option>
          <?php foreach($drivers as $d): ?>
            <option value="<?= $d['id'] ?>" <?= $driver==$d['id']?'selected':'' ?>><?= htmlspecialchars($d['name']) ?></option>
          <?php endforeach; ?>
        </select>
      </div>
      <div>
        <label>Area</label>
        <select name="area">
          <option value="">All</option>
          <?php foreach($areas as $a): ?>
            <option value="<?= $a['id'] ?>" <?= $area==$a['id']?'selected':'' ?>><?= htmlspecialchars($a['name']) ?></option>
          <?php endforeach; ?>
        </select>
      </div>
      <div>
        <label>Status</label>
        <select name="status">
          <option value="">All</option>
          <?php foreach($statuses as $s): ?>
            <option value="<?= $s ?>" <?= $status==$s?'selected':'' ?>><?= ucfirst($s) ?></option>
          <?php endforeach; ?>
        </select>
      </div>
      <div style="align-self:end;">
        <button class="btn primary" type="submit">Filter</button>
      </div>
    </form>

    <!-- Finance Summary -->
    <div class="finance-summary">
      <div class="box">
        <h2><?= $totalOrders ?></h2>
        <p>Orders</p>
      </div>
      <div class="box">
        <h2><?= number_format($totalAmount,2) ?></h2>
        <p>Total Amount</p>
      </div>
      <div class="box">
        <h2><?= number_format($totalDelivery,2) ?></h2>
        <p>Delivery Fees</p>
      </div>
    </div>

    <!-- Orders Table -->
    <table class="table">
      <thead>
        <tr>
          <th>ID</th><th>User</th><th>Area</th><th>Driver</th>
          <th>Status</th><th>Amount</th><th>Date</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach($orders as $o): ?>
          <tr>
            <td>#<?= $o['id']; ?></td>
            <td><?= htmlspecialchars($o['user_name']); ?></td>
            <td><?= htmlspecialchars($o['area_name']); ?></td>
            <td><?= htmlspecialchars($o['driver_name'] ?? '-'); ?></td>
            <td><span class="badge <?= $o['status']; ?>"><?= $o['status']; ?></span></td>
            <td><?= number_format($o['total_amount'] ?? 0,2) ?></td>
            <td><?= $o['created_at']; ?></td>
          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</main>

<div class="footer">© <?= date('Y'); ?> Propane Service</div>
</body>
</html>
