<?php
session_start();
require 'db.php';
require 'lib/phpqrcode.php';

if (!isset($_SESSION['admin_id'])) {
    header("Location: admin_login.php");
    exit;
}

// Handle Add / Extend / Toggle / Delete
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['add_user'])) {
        $token = bin2hex(random_bytes(16));
        $expires = date('Y-m-d H:i:s', strtotime('+365 days'));
        $stmt = $pdo->prepare("INSERT INTO users (name, phone, login_token, login_token_expires, active) VALUES (?,?,?,?,1)");
        $stmt->execute([$_POST['name'], $_POST['phone'], $token, $expires]);
        header("Location: admin_users.php");
        exit;
    }

    if (isset($_POST['extend_token'])) {
        $expires = date('Y-m-d H:i:s', strtotime('+365 days'));
        $stmt = $pdo->prepare("UPDATE users SET login_token_expires=? WHERE id=?");
        $stmt->execute([$expires, $_POST['user_id']]);
        header("Location: admin_users.php");
        exit;
    }

    if (isset($_POST['toggle_active'])) {
        $stmt = $pdo->prepare("UPDATE users SET active=? WHERE id=?");
        $stmt->execute([$_POST['active'], $_POST['user_id']]);
        header("Location: admin_users.php");
        exit;
    }

    if (isset($_POST['delete_user'])) {
        $stmt = $pdo->prepare("DELETE FROM users WHERE id=?");
        $stmt->execute([$_POST['user_id']]);
        header("Location: admin_users.php");
        exit;
    }
}

// Search / filter
$search = $_GET['search'] ?? '';
$query = "SELECT u.*, a.name AS area_name 
          FROM users u 
          LEFT JOIN areas a ON u.area_id=a.id 
          WHERE CONCAT(u.id,' ',u.name,' ',u.phone,' ',IFNULL(u.address,'')) LIKE ? 
          ORDER BY u.id DESC";
$stmt = $pdo->prepare($query);
$stmt->execute(["%$search%"]);
$users = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html>
<head>
<meta charset="utf-8">
<title>Manage Users</title>
<link rel="stylesheet" href="assets/css/styles.css">
<style>
.table input { width: 100%; padding:4px; }
.qr-img { max-width:80px; margin-top:5px; display:block; }
.copy-btn { margin-top:3px; font-size:12px; padding:2px 6px; }
.expired { color:red; font-weight:bold; }
</style>
</head>
<body>
<div class="header">
  <div class="header-inner container">
    <div class="brand"><div class="logo"></div><h1>Users</h1></div>
    <a class="btn secondary" href="admin_panel.php">Dashboard</a>
  </div>
</div>
<main class="container">
  <div class="card">
    <h2>Add User</h2>
    <div class="hr"></div>
    <form method="post" style="display:flex;gap:10px;flex-wrap:wrap">
      <input class="input" name="name" placeholder="Name">
      <input class="input" name="phone" placeholder="Phone">
      <button class="btn" type="submit" name="add_user">Add & Generate Link</button>
    </form>
  </div>

  <div class="card" style="margin-top:16px">
    <h2>Search / Filter</h2>
    <form method="get" style="display:flex;gap:10px;flex-wrap:wrap">
      <input class="input" name="search" value="<?php echo htmlspecialchars($search); ?>" placeholder="Search by id, name, phone, address">
      <button class="btn" type="submit">Search</button>
      <a class="btn secondary" href="admin_users.php">Reset</a>
    </form>
  </div>

  <div class="card" style="margin-top:16px">
    <h2>Users List</h2>
    <div class="hr"></div>
    <table class="table">
      <thead>
        <tr>
          <th>ID</th>
          <th>Name</th>
          <th>Phone</th>
          <th>Link / QR</th>
          <th>Expires</th>
          <th>Active</th>
          <th>Actions</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach($users as $u): 
            $link = 'https://diyari-iq.com/propane/login.php?token='.$u['login_token'];
            ob_start();
            QRcode::png($link, null, QR_ECLEVEL_L, 3);
            $qrImage = base64_encode(ob_get_clean());
            $expired = (strtotime($u['login_token_expires']) < time());
        ?>
        <tr>
          <td><?php echo $u['id']; ?></td>
          <td><?php echo htmlspecialchars($u['name']); ?></td>
          <td><?php echo htmlspecialchars($u['phone']); ?></td>
          <td>
            <input id="link_<?php echo $u['id']; ?>" type="text" value="<?php echo $link; ?>" readonly>
            <button class="copy-btn" onclick="navigator.clipboard.writeText(document.getElementById('link_<?php echo $u['id']; ?>').value)">Copy</button>
            <img class="qr-img" id="qr_<?php echo $u['id']; ?>" src="data:image/png;base64,<?php echo $qrImage; ?>" alt="QR">
            <button class="btn" onclick="downloadQRFrame('<?php echo $u['id']; ?>')">Download QR</button>
          </td>
          <td class="<?php echo $expired ? 'expired' : ''; ?>"><?php echo $u['login_token_expires']; ?></td>
          <td><?php echo $u['active'] ? 'Yes' : 'No'; ?></td>
          <td style="display:flex;gap:5px;flex-wrap:wrap">
            <form method="post">
              <input type="hidden" name="user_id" value="<?php echo $u['id']; ?>">
              <button class="btn" type="submit" name="extend_token">Extend 1yr</button>
            </form>
            <form method="post">
              <input type="hidden" name="user_id" value="<?php echo $u['id']; ?>">
              <input type="hidden" name="active" value="<?php echo $u['active'] ? 0 : 1; ?>">
              <button class="btn secondary" type="submit" name="toggle_active">
                <?php echo $u['active'] ? 'Deactivate' : 'Activate'; ?>
              </button>
            </form>
            <form method="post" onsubmit="return confirm('Delete this user?')">
              <input type="hidden" name="user_id" value="<?php echo $u['id']; ?>">
              <button class="btn danger" type="submit" name="delete_user">Delete</button>
            </form>
          </td>
        </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</main>

<script>
function downloadQRFrame(id) {
    const img = document.getElementById('qr_' + id);

    const image = new Image();
    image.src = img.src;
    image.onload = () => {
        const border = 30; // space for border and ID
        const paddingTop = 50; // space for header
        const canvas = document.createElement('canvas');
        canvas.width = image.width + border * 2;
        canvas.height = image.height + paddingTop + border;

        const ctx = canvas.getContext('2d');

        // White background
        ctx.fillStyle = "white";
        ctx.fillRect(0, 0, canvas.width, canvas.height);

        // Draw border
        ctx.strokeStyle = "black";
        ctx.lineWidth = 4;
        ctx.strokeRect(border / 2, paddingTop - border / 2, image.width + border, image.height + border);

        // Draw ID at the top center
        ctx.fillStyle = "black";
        ctx.font = "24px Arial";
        ctx.textAlign = "center";
        ctx.fillText(`ID: ${id}`, canvas.width / 2, 30);

        // Draw QR image
        ctx.drawImage(image, border, paddingTop);

        // Trigger download
        const link = document.createElement('a');
        link.href = canvas.toDataURL('image/png');
        link.download = `QR_${id}.png`;
        link.click();
    };
}
</script>

<div class="footer">© <?php echo date('Y'); ?> Propane Service</div>
</body>
</html>
