<?php
require 'db.php';
require 'phpqrcode/qrlib.php'; // adjust path

if (!isset($_GET['user_id'])) {
    die("No user ID");
}

$user_id = intval($_GET['user_id']);

// Fetch login token for user
$stmt = $pdo->prepare("SELECT login_token FROM users WHERE id=?");
$stmt->execute([$user_id]);
$user = $stmt->fetch();

if (!$user) {
    die("User not found");
}

$login_url = "https://diyari-iq.com/propane/login.php?token=" . urlencode($user['login_token']);

// Output QR as PNG
header('Content-Type: image/png');
QRcode::png($login_url, null, QR_ECLEVEL_L, 6);
