<?php
session_start();

// Available languages
$languages = ['en', 'ar', 'ku'];

// If user changes language
if (isset($_GET['lang']) && in_array($_GET['lang'], $languages)) {
    $_SESSION['lang'] = $_GET['lang'];
}

// Default = English
$lang = $_SESSION['lang'] ?? 'en';

// Translations
$texts = [
    'en' => [
        // User translations
        'filter_by_status' => 'Filter by Status',
'apply_filters' => 'Apply Filters',
'reset_filters' => 'Reset Filters',
'no_orders_match' => 'No orders match your filters',
'cancelled' => 'Cancelled',
'you' => 'You',
'driver' => 'Driver',
        'confirm_order_message' => 'Are you sure you want to place an order for 1 propane bottle?',
        'confirm_order' => 'Confirm Order',
        'welcome' => 'Welcome',
        'dashboard' => 'Dashboard',
        'orders' => 'My Orders',
        'new_order' => 'Place New Order',
        'profile' => 'Profile',
        'logout' => 'Logout',
        'login' => 'Login',
        'latest_order' => 'Latest Order',
        'status' => 'Status',
        'copy_link' => 'Copy My Login Link',
        'edit_profile' => 'Edit Profile',
        'name' => 'Name',
        'phone' => 'Phone',
        'address' => 'Address',
        'zone' => 'zone',
        'gps_latitude' => 'GPS Latitude',
        'gps_longitude' => 'GPS Longitude',
        'use_my_location' => 'Use my location',
        'update_profile' => 'Update Profile',
        'order_bottle' => 'Order a Propane Bottle',
        'order_description' => 'One tap request. A driver in your zone will accept and deliver.',
        'order_button' => 'Order 1 Bottle',
        'how_it_works' => 'How it works',
        'order_more' => 'Need more than 1? Quantity can be enabled later.',
        'previous_orders' => 'Previous Orders',
        'date' => 'Date',
        'quantity' => 'Quantity',
        'actions' => 'Actions',
        'cancel' => 'Cancel',
        'no_orders' => 'No orders yet.',
        'propane_service' => 'Propane Service',
        'dashboard_link' => 'Dashboard',
        'profile_link' => 'Profile',
        'orders_link' => 'Orders',
        'place_new_order' => 'Place New Order',
        'pending' => 'Pending',
        'confirmed' => 'Confirmed',
        'accepted' => 'Accepted',
        'delivered' => 'Delivered',
        
        // Driver translations
        'driver_panel' => 'Driver Panel',
        'main_stock' => 'Main Stock',
        'filled' => 'Filled',
        'empty' => 'Empty',
        'sold' => 'Sold',
        'refresh' => 'Refresh',
        'orders_in_zone' => 'Orders in your zone',
        'user' => 'User',
        'gps' => 'GPS',
        'map' => 'Map',
        'take' => 'Take',
        'mark_delivered' => 'Mark Delivered',
        'manual_stock_management' => 'Manual Stock Management',
        'exchange_empty_cylinders' => 'Exchange Empty Cylinders (Return)',
        'manual_sell' => 'Manual Sell',
        'update_stock' => 'Update Stock',
        'sold_cylinders_returned' => 'Sold cylinders returned',
        'sell_filled_cylinders' => 'Sell filled cylinders'
    ],
    'ar' => [
        // User translations
        'filter_by_status' => 'تصفية حسب الحالة',
'apply_filters' => 'تطبيق الفلاتر',
'reset_filters' => 'إعادة تعيين الفلاتر',
'no_orders_match' => 'لا توجد طلبات تطابق الفلاتر الخاصة بك',
'cancelled' => 'ملغى',
'you' => 'أنت',
'driver' => 'السائق',
        'confirm_order' => 'تأكيد الطلب',
        'confirm_order_message' => 'هل أنت متأكد أنك تريد طلب أسطوانة غاز واحدة؟',
        'welcome' => 'أهلاً بك',
        'dashboard' => 'لوحة التحكم',
        'orders' => 'طلباتي',
        'new_order' => 'طلب جديد',
        'profile' => 'الملف الشخصي',
        'logout' => 'تسجيل خروج',
        'login' => 'تسجيل الدخول',
        'latest_order' => 'آخر طلب',
        'status' => 'الحالة',
        'copy_link' => 'نسخ رابط الدخول الخاص بي',
        'edit_profile' => 'تعديل الملف الشخصي',
        'name' => 'الاسم',
        'phone' => 'الهاتف',
        'address' => 'العنوان',
        'zone' => 'المنطقة',
        'gps_latitude' => 'خط العرض',
        'gps_longitude' => 'خط الطول',
        'use_my_location' => 'استخدم موقعي',
        'update_profile' => 'تحديث الملف',
        'order_bottle' => 'طلب أسطوانة غاز',
        'order_description' => 'طلب بنقرة واحدة. سيرى السائقون في منطقتك طلبك وسيقبل الأسرع منهم بالتوصيل.',
        'order_button' => 'طلب أسطوانة واحدة',
        'how_it_works' => 'كيف تعمل الخدمة',
        'order_more' => 'تحتاج أكثر من واحدة؟ يمكن تفعيل خاصية الكمية لاحقاً.',
        'previous_orders' => 'الطلبات السابقة',
        'date' => 'التاريخ',
        'quantity' => 'الكمية',
        'actions' => 'الإجراءات',
        'cancel' => 'إلغاء',
        'no_orders' => 'لا توجد طلبات بعد.',
        'propane_service' => 'خدمة الغاز',
        'dashboard_link' => 'لوحة التحكم',
        'profile_link' => 'الملف الشخصي',
        'orders_link' => 'الطلبات',
        'place_new_order' => 'طلب جديد',
        'pending' => 'قيد الانتظار',
        'confirmed' => 'تم التأكيد',
        'accepted' => 'مقبول',
        'delivered' => 'تم التوصيل',
        
        // Driver translations
        'driver_panel' => 'لوحة السائق',
        'main_stock' => 'المخزون الرئيسي',
        'filled' => 'ممتلئة',
        'empty' => 'فارغة',
        'sold' => 'مباعة',
        'refresh' => 'تحديث',
        'orders_in_zone' => 'الطلبات في منطقتك',
        'user' => 'المستخدم',
        'gps' => 'GPS',
        'map' => 'خريطة',
        'take' => 'أخذ',
        'mark_delivered' => 'تم التوصيل',
        'manual_stock_management' => 'إدارة المخزون اليدوية',
        'exchange_empty_cylinders' => 'تبادل الأسطوانات الفارغة (إرجاع)',
        'manual_sell' => 'بيع يدوي',
        'update_stock' => 'تحديث المخزون',
        'sold_cylinders_returned' => 'الأسطوانات المباعة المرتجعة',
        'sell_filled_cylinders' => 'بيع الأسطوانات الممتلئة'
    ],
    'ku' => [
        // User translations
        'filter_by_status' => 'پاڵێوراوەکان بەپێی دۆخ',
'apply_filters' => 'جێبەجێکردنی فلتەرەکان',
'reset_filters' => 'دووبارە ڕێکخستنەوەی فلتەرەکان',
'no_orders_match' => 'هیچ داواکارییەک نابێتە هاوشێوەی فلتەرەکانت',
'cancelled' => 'هەڵوەشایەوە',
'you' => 'تۆ',
'driver' => 'شۆفێر',
        'confirm_order' => 'داواکارییەکە دڵنیا بکەرەوە',
        'confirm_order_message' => 'ئایا دەتەوێت ١ سەلیندەری گاز داوا بکەیت؟',
        'welcome' => 'بەخێربێیت',
        'dashboard' => 'داشبۆرد',
        'orders' => 'داواکاریەکانم',
        'new_order' => 'داواکارییەکی نوێ',
        'profile' => 'پڕۆفایل',
        'logout' => 'چوونەدەرەوە',
        'login' => 'چوونەژوورەوە',
        'latest_order' => 'دوایین داواکاری',
        'status' => 'بار',
        'copy_link' => 'لینکی چوونەژوورەوەم کۆپی بکە',
        'edit_profile' => 'دەستکاریکردنی پڕۆفایل',
        'name' => 'ناو',
        'phone' => 'تەلەفۆن',
        'address' => 'ناونیشان',
        'zone' => 'زون',
        'gps_latitude' => 'پانیی GPS',
        'gps_longitude' => 'درێژیی GPS',
        'use_my_location' => 'شوێنی من بەکاربهێنە',
        'update_profile' => 'نوێکردنەوەی پڕۆفایل',
        'order_bottle' => 'داواکاری سەلیندەری گاز',
        'order_description' => 'داواکارییەک بە یەک کرتە. شۆفێرەکانی ناو زونەکەت داواکارییەکە دەبینن و خێراترین شۆفێر ئەنجامی دەدات.',
        'order_button' => 'داواکاری ١ سەلیندەر',
        'how_it_works' => 'چۆن کار دەکات',
        'order_more' => 'پێویستت بە زیاتر لە ١ە؟ دەتوانیت ژمارەی زیاتر دواتر دیاری بکەیت.',
        'previous_orders' => 'داواکاریەکانی پێشوو',
        'date' => 'بەروار',
        'quantity' => 'ژمارە',
        'actions' => 'کردارەکان',
        'cancel' => 'پەشیمانبوونەوە',
        'no_orders' => 'هێشتا داواکاریت نییە.',
        'propane_service' => 'خزمەتگوزاری گاز',
        'dashboard_link' => 'داشبۆرد',
        'profile_link' => 'پڕۆفایل',
        'orders_link' => 'داواکاریەکان',
        'place_new_order' => 'داواکارییەکی نوێ',
        'pending' => 'چاوەروان',
        'confirmed' => 'پشتڕاستکراوە',
        'accepted' => 'قبوڵکراو',
        'delivered' => 'گەیاندرا',
        
        // Driver translations
        'driver_panel' => 'پانێلی شۆفێر',
        'main_stock' => 'ستۆکی سەرەکی',
        'filled' => 'پڕ',
        'empty' => 'بەتاڵ',
        'sold' => 'فرۆشراو',
        'refresh' => 'نوێکردنەوە',
        'orders_in_zone' => 'داواکاریەکان لە زونەکەتدا',
        'user' => 'بەکارهێنەر',
        'gps' => 'GPS',
        'map' => 'نەخشە',
        'take' => 'وەرگرتن',
        'mark_delivered' => 'نیشانەی گەیاندن',
        'manual_stock_management' => 'بەڕێوەبەریی ستۆکی دەستی',
        'exchange_empty_cylinders' => 'گۆڕینی سەلیندەری بەتاڵەکان (گەڕاندنەوە)',
        'manual_sell' => 'فرۆشتی دەستی',
        'update_stock' => 'نوێکردنەوەی ستۆک',
        'sold_cylinders_returned' => 'سەلیندەرە فرۆشراوە گەڕاوەکان',
        'sell_filled_cylinders' => 'فرۆشتی سەلیندەری پڕ'
    ]
];

// Helper function
function t($key) {
    global $texts, $lang;
    return $texts[$lang][$key] ?? $key;
}
?>