<?php
session_start();
require 'db.php';

// Ensure token is present
if (!isset($_GET['token']) || empty($_GET['token'])) {
    die("Invalid link");
}

// Decode token safely
$token = urldecode($_GET['token']);

// Fetch user
$stmt = $pdo->prepare("SELECT * FROM users WHERE login_token=? AND active=1 AND login_token_expires >= NOW()");
$stmt->execute([$token]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$user) {
    die("Invalid or expired link");
}

// Log the user in
$_SESSION['user_id'] = $user['id'];
session_regenerate_id(true);

// Redirect to user dashboard
header("Location: user_dashboard.php");
exit;
