<?php
session_start();
require 'db.php';
require 'lang.php';
if (!isset($_SESSION['user_id'])) { header("Location: login.php"); exit; }

$user_id = $_SESSION['user_id'];
$orders = $pdo->prepare("SELECT * FROM orders WHERE user_id=? ORDER BY created_at DESC");
$orders->execute([$user_id]);
$orders = $orders->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html>
<head><meta charset="utf-8"><title><?php echo t('orders'); ?></title></head>
<body>
  <h1><?php echo t('orders'); ?></h1>
  <table border="1">
    <tr><th>ID</th><th><?php echo t('status'); ?></th><th>Date</th></tr>
    <?php foreach($orders as $o): ?>
      <tr>
        <td><?php echo $o['id']; ?></td>
        <td><?php echo htmlspecialchars($o['status']); ?></td>
        <td><?php echo $o['created_at']; ?></td>
      </tr>
    <?php endforeach; ?>
  </table>
  <a href="dashboard.php"><?php echo t('dashboard'); ?></a>
</body>
</html>
