<?php
session_start();
require 'db.php';
require 'lang.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

$user_id = $_SESSION['user_id'];
$message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Create a new order for this user with user's area
    $stmt = $pdo->prepare("INSERT INTO orders (user_id, area_id, qty)
                           SELECT id, area_id, 1 FROM users WHERE id = ?");
    $stmt->execute([$user_id]);
    $message = "Your order has been placed!";
}

// Set direction based on language
$dir = ($lang == 'ar') ? 'rtl' : 'ltr';
?>
<!DOCTYPE html>
<html dir="<?php echo $dir; ?>">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title><?php echo t('dashboard'); ?> — Propane Service</title>
  <style>
    :root {
      --primary: #4361ee;
      --secondary: #3a0ca3;
      --success: #4cc9f0;
      --danger: #f72585;
      --warning: #fca311;
      --light: #f8f9fa;
      --dark: #212529;
      --gray: #6c757d;
      --light-gray: #e9ecef;
      --border-radius: 12px;
      --box-shadow: 0 10px 25px rgba(0,0,0,0.1);
      --transition: all 0.3s ease;
    }

    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
      font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    }

    body {
      background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%);
      min-height: 100vh;
      padding: 20px;
      color: var(--dark);
      direction: <?php echo $dir; ?>;
    }

    .navbar {
      background: white;
      border-radius: var(--border-radius);
      box-shadow: var(--box-shadow);
      padding: 15px 25px;
      margin-bottom: 30px;
      display: flex;
      justify-content: space-between;
      align-items: center;
      flex-wrap: wrap;
      gap: 15px;
      animation: slideDown 0.5s ease;
    }

    .navbar a {
      color: var(--dark);
      text-decoration: none;
      padding: 8px 15px;
      border-radius: var(--border-radius);
      transition: var(--transition);
      font-weight: 500;
    }

    .navbar a:hover {
      background: var(--primary);
      color: white;
    }

    .language-switcher {
      display: flex;
      gap: 10px;
    }

    .lang-btn {
      padding: 5px 10px;
      border: 1px solid var(--primary);
      border-radius: var(--border-radius);
      background: white;
      color: var(--primary);
      cursor: pointer;
      transition: var(--transition);
      text-decoration: none;
      font-size: 0.9rem;
    }

    .lang-btn.active {
      background: var(--primary);
      color: white;
    }

    .lang-btn:hover {
      background: var(--primary);
      color: white;
    }

    .container {
      max-width: 1200px;
      margin: 0 auto;
      padding: 0 15px;
    }

    .grid {
      display: grid;
      gap: 25px;
    }

    .grid-2 {
      grid-template-columns: repeat(auto-fit, minmax(400px, 1fr));
    }

    .card {
      background: white;
      border-radius: var(--border-radius);
      box-shadow: var(--box-shadow);
      padding: 25px;
      margin-bottom: 25px;
      transition: var(--transition);
      animation: fadeIn 0.6s ease;
    }

    .card:hover {
      transform: translateY(-5px);
      box-shadow: 0 15px 30px rgba(0,0,0,0.15);
    }

    .card h1, .card h2 {
      margin-bottom: 15px;
      color: var(--primary);
    }

    .hr {
      height: 1px;
      background: var(--light-gray);
      margin: 20px 0;
    }

    .muted {
      color: var(--gray);
      line-height: 1.6;
    }

    .btn {
      display: inline-block;
      padding: 12px 25px;
      background: var(--primary);
      color: white;
      border: none;
      border-radius: var(--border-radius);
      cursor: pointer;
      text-decoration: none;
      font-weight: 600;
      transition: var(--transition);
      box-shadow: 0 4px 6px rgba(67, 97, 238, 0.3);
      text-align: center;
    }

    .btn:hover {
      transform: translateY(-2px);
      box-shadow: 0 6px 12px rgba(67, 97, 238, 0.4);
    }

    .btn.block {
      display: block;
      width: 100%;
    }

    .badge {
      padding: 8px 15px;
      border-radius: 20px;
      font-size: 0.9rem;
      font-weight: 600;
      display: inline-block;
      margin-bottom: 15px;
      animation: pulse 2s infinite;
    }

    .delivered {
      background: rgba(76, 201, 240, 0.2);
      color: #0a6c74;
      border-left: 4px solid var(--success);
    }

    ul {
      padding-left: 20px;
      margin: 15px 0;
    }

    li {
      margin-bottom: 10px;
      line-height: 1.6;
    }

    .footer {
      text-align: center;
      padding: 20px;
      color: var(--gray);
      margin-top: 40px;
    }

    /* Popup Styles */
    .popup-overlay {
      position: fixed;
      top: 0;
      left: 0;
      right: 0;
      bottom: 0;
      background: rgba(0, 0, 0, 0.7);
      display: flex;
      justify-content: center;
      align-items: center;
      z-index: 1000;
      opacity: 0;
      visibility: hidden;
      transition: var(--transition);
    }

    .popup-overlay.active {
      opacity: 1;
      visibility: visible;
    }

    .popup-content {
      background: white;
      border-radius: var(--border-radius);
      box-shadow: var(--box-shadow);
      padding: 30px;
      width: 90%;
      max-width: 500px;
      transform: translateY(-50px);
      transition: var(--transition);
      text-align: center;
      position: relative;
    }

    .popup-overlay.active .popup-content {
      transform: translateY(0);
    }

    .popup-close {
      position: absolute;
      top: 15px;
      right: 15px;
      background: none;
      border: none;
      font-size: 1.5rem;
      cursor: pointer;
      color: var(--gray);
    }

    .popup-title {
      color: var(--primary);
      margin-bottom: 15px;
    }

    .popup-message {
      margin-bottom: 25px;
      color: var(--dark);
    }

    .popup-buttons {
      display: flex;
      justify-content: center;
      gap: 15px;
    }

    .popup-btn {
      padding: 10px 25px;
      border: none;
      border-radius: var(--border-radius);
      cursor: pointer;
      font-weight: 600;
      transition: var(--transition);
    }

    .popup-btn.confirm {
      background: var(--primary);
      color: white;
    }

    .popup-btn.confirm:hover {
      background: var(--secondary);
    }

    .popup-btn.cancel {
      background: var(--light-gray);
      color: var(--dark);
    }

    .popup-btn.cancel:hover {
      background: var(--gray);
      color: white;
    }

    .propane-img {
      max-width: 100%;
      height: auto;
      cursor: pointer;
      transition: transform 0.3s ease;
    }

    .propane-img:hover {
      transform: scale(1.05);
    }

    @keyframes slideDown {
      from {
        opacity: 0;
        transform: translateY(-20px);
      }
      to {
        opacity: 1;
        transform: translateY(0);
      }
    }

    @keyframes fadeIn {
      from {
        opacity: 0;
        transform: translateY(20px);
      }
      to {
        opacity: 1;
        transform: translateY(0);
      }
    }

    @keyframes pulse {
      0% {
        box-shadow: 0 0 0 0 rgba(76, 201, 240, 0.4);
      }
      70% {
        box-shadow: 0 0 0 10px rgba(76, 201, 240, 0);
      }
      100% {
        box-shadow: 0 0 0 0 rgba(76, 201, 240, 0);
      }
    }

    @media (max-width: 768px) {
      .navbar {
        flex-direction: column;
        align-items: flex-start;
      }
      
      .grid-2 {
        grid-template-columns: 1fr;
      }
      
      .popup-buttons {
        flex-direction: column;
      }
    }
  </style>
  <script>
    document.addEventListener('DOMContentLoaded', function() {
      // Add animation to cards
      const cards = document.querySelectorAll('.card');
      cards.forEach((card, index) => {
        card.style.animationDelay = `${index * 0.2}s`;
      });

      // Popup functionality
      const propaneImage = document.getElementById('propane-image');
      const popupOverlay = document.getElementById('popup-overlay');
      const closePopup = document.getElementById('close-popup');
      const cancelOrder = document.getElementById('cancel-order');
      const confirmOrder = document.getElementById('confirm-order');
      const orderForm = document.getElementById('order-form');

      // Open popup when clicking propane image
      propaneImage.addEventListener('click', function() {
        popupOverlay.classList.add('active');
      });

      // Close popup when clicking X or cancel
      closePopup.addEventListener('click', closePopupFunc);
      cancelOrder.addEventListener('click', closePopupFunc);

      // Confirm order
      confirmOrder.addEventListener('click', function() {
        // Submit the form
        orderForm.submit();
      });

      // Close popup when clicking outside content
      popupOverlay.addEventListener('click', function(e) {
        if (e.target === popupOverlay) {
          closePopupFunc();
        }
      });

      function closePopupFunc() {
        popupOverlay.classList.remove('active');
      }

      // Add animation to button
      const orderBtn = document.querySelector('form button');
      if (orderBtn) {
        orderBtn.addEventListener('mouseenter', function() {
          this.style.transform = 'scale(1.05)';
        });
        
        orderBtn.addEventListener('mouseleave', function() {
          this.style.transform = 'scale(1)';
        });
      }
    });
  </script>
</head>
<body>

<!-- NAVBAR -->
<div class="navbar">
    <div>
        <a href="user_dashboard.php"><?php echo t('dashboard'); ?></a>
        <a href="user_orders.php"><?php echo t('orders'); ?></a>
        <a href="profile.php"><?php echo t('profile'); ?></a>
        <a href="logout.php"><?php echo t('logout'); ?></a>
    </div>
    

</div>

<main class="container grid grid-2">
  <section class="card">
    <h1><?php echo t('order_bottle'); ?></h1>
    <p class="muted"><?php echo t('order_description'); ?></p>
    <div class="hr"></div>
    <?php if($message): ?>
      <p class="badge delivered"><?php echo htmlspecialchars($message); ?></p>
    <?php endif; ?>
    
    <!-- Full size image as button -->
    <form method="post" id="order-form" style="margin-top:10px; text-align: center;">
      <img src="propane.png" alt="Order Propane" id="propane-image" class="propane-img">
    </form>
  </section>
</main>
    <div class="language-switcher">
      <a href="?lang=en" class="lang-btn <?php echo $lang == 'en' ? 'active' : ''; ?>">EN</a>
      <a href="?lang=ar" class="lang-btn <?php echo $lang == 'ar' ? 'active' : ''; ?>">AR</a>
      <a href="?lang=ku" class="lang-btn <?php echo $lang == 'ku' ? 'active' : ''; ?>">KU</a>
    </div>
<!-- Order Confirmation Popup -->
<div class="popup-overlay" id="popup-overlay">
  <div class="popup-content">
    <button class="popup-close" id="close-popup">&times;</button>
    <h2 class="popup-title"><?php echo t('confirm_order'); ?></h2>
    <p class="popup-message"><?php echo t('confirm_order_message'); ?></p>
    <div class="popup-buttons">
      <button class="popup-btn cancel" id="cancel-order"><?php echo t('cancel'); ?></button>
      <button class="popup-btn confirm" id="confirm-order"><?php echo t('confirm'); ?></button>
    </div>
  </div>
</div>

<div class="footer">© <?php echo date('Y'); ?> <?php echo t('propane_service'); ?></div>
</body>
</html>